# Pytheia -- Oracle of Pointing

**Installation & Testing Guide (v1.0.0)**\
**September 2025**

------------------------------------------------------------------------

## 1. Package Contents

### Reveal Bundle (docs & guides)

-   License & IP Protection Note (New Jersey jurisdiction)
-   README_CLIENT.md
-   Release Notes
-   One-Page Brochure
-   README_FIRST.txt

### Software Package (Pytheia_v1.0.0)

-   Pytheia100_core.py ........ Core pointing correction engine\
-   Pytheia100_main.py ........ Main execution script\
-   Config.py ................. User-adjustable configuration
    parameters\
-   Test_pointing_model.py .... Testing script for validation\
-   Ecam_astronomy_pm-02-04-2025.dat .... Astronomy pointing model data

**Security & Integrity Files:** - Pytheia_guard.py .......... Guard
module enforcing license/IP compliance\
- Pytheia_license.json ...... Machine-readable license definition\
- Inject_integrity.py ....... Script for embedding/verifying integrity\
- Integrity.json ............ Integrity record (checksums/hashes)\
- Integrity.sig ............. Digital signature file\
- Pytheia_public_key.pem .... Public key for validating authenticity

-   README_CLIENT.txt ......... Quick-start instructions

------------------------------------------------------------------------

## 2. Installation & Setup

1.  Create a directory for Pytheia:

    ``` bash
    mkdir ~/Pytheia_v1.0.0
    cd ~/Pytheia_v1.0.0
    ```

2.  Copy the software package files into this directory.\
    Place Reveal Bundle docs in a `/docs/` subfolder for clarity
    (optional).

3.  Set up a Python environment (Python 3.9+ recommended):

    ``` bash
    python -m venv venv
    source venv/bin/activate   # Linux/macOS
    venv\Scripts\activate    # Windows
    ```

4.  Install dependencies:

    ``` bash
    pip install pandas numpy
    ```

------------------------------------------------------------------------

## 3. Verifying Integrity (Recommended)

1.  Check file integrity:

    ``` bash
    python Inject_integrity.py --verify
    ```

2.  This will compare checksums from `Integrity.json`.\
    If configured, it will also validate `Integrity.sig` using
    `Pytheia_public_key.pem`.

-   **If verification passes:** The package is authentic.\
-   **If verification fails:** Stop and notify Orionis immediately.

------------------------------------------------------------------------

## 4. Running Pytheia

1.  Edit `Config.py` if necessary (default values are provided).\

2.  Run the main program:

    ``` bash
    python Pytheia100_main.py
    ```

3.  Validate with the test model:

    ``` bash
    python Test_pointing_model.py
    ```

------------------------------------------------------------------------

## 5. Documentation

-   `README_CLIENT.txt` → Quick start\
-   `User Manual.pdf` → Detailed usage and troubleshooting\
-   `Release_Notes.md` → Version details\
-   `License & IP Note.docx` → Legal terms

------------------------------------------------------------------------

## 6. Notes

-   Pytheia is the exclusive intellectual property of Orionis Group.\
-   Use is restricted under the laws of the State of New Jersey, USA.\
-   Unauthorized distribution or modification is strictly prohibited.
