# Pytheia -- Oracle of Pointing

**Client README (v1.0.0)**\
**September 2025**

------------------------------------------------------------------------

## 1. Introduction

Pytheia is Orionis Group's flagship software for **telescope pointing
correction and automation.** Developed in Python, it provides robust and
production-grade functionality for observatories of all scales.

------------------------------------------------------------------------

## 2. System Requirements

-   **Python:** 3.9+\
-   **Dependencies:**
    -   pandas\
    -   numpy\
    -   (other required libraries -- listed in `requirements.txt`)\
-   **OS:** Compatible with Windows, Linux, and macOS

------------------------------------------------------------------------

## 3. Installation

1.  Unpack the provided **Pytheia_v1.0.0.zip** package.\

2.  Open a terminal in the Pytheia directory.\

3.  Install dependencies:

    ``` bash
    pip install -r requirements.txt
    ```

------------------------------------------------------------------------

## 4. Running Pytheia

Execute the main program with:

``` bash
python main.py
```

------------------------------------------------------------------------

## 5. Configuration

-   The **config.py** file contains user-adjustable parameters.\
-   Default configuration works for most environments.\
-   Refer to the **User Manual** for detailed parameter descriptions.

------------------------------------------------------------------------

## 6. Support & Feedback

-   Contact Orionis Group for assistance or to report issues.\
-   Feedback from tests is highly appreciated to improve Pytheia.

------------------------------------------------------------------------

## 7. Intellectual Property Notice

Pytheia and its documentation are the exclusive intellectual property of
Orionis Group.\
Use is restricted under the terms of the attached **License & IP
Protection Note.**
