# Pytheia100 v1.0.0 — Client Guide (Gold Package)

This guide explains how to install, verify, configure, and run **Pytheia100 v1.0.0** on Windows/macOS/Linux.

---

## 1) What’s in the package

- **Pytheia100_main.py** — Performs integrity + license boot, maps `config.py`. Supports Windows color handling and a monochrome mode.
- **Pytheia100_core.py** — Guarded: cannot be run directly.
- **config.py** — Client-editable configuration: input data file, selected terms, output directory, mode (`azel`/`hadec`), latitude, optional aux params.
- **pytheia_guard.py** — Production guard for *Ed25519* integrity & license verification, seat locking, and near‑expiry warnings.
- **INTEGRITY.json / INTEGRITY.sig** — Integrity manifest and its Ed25519 signature.
- **pytheia_license.json** — Signed license payload for your org.
- **validate_integrity.py** — (optional) CLI to validate the integrity manifest locally.

---

## 2) System requirements

- Python 3.9–3.12 recommended
- See `requirements.txt` in this folder for pinned libs. (Windows wheels are available for the chosen pins.)

---

## 3) Install dependencies

```bash
# (Recommended) inside a virtual environment:
python -m venv .venv
# Windows
.\.venv\Scripts\activate
# macOS/Linux
source .venv/bin/activate

pip install -r requirements.txt
```

Notes:
- We use **`termcolor`** for colored console output inside the core (not the `colored` package). We also add **`colorama`** to improve Windows rendering.

---

## 4) Verify integrity & license (optional)

**Integrity:** We sign `INTEGRITY.json`.

- To validate locally from the CLI:
  ```bash
  python validate_integrity.py --root .
  ```
  This recomputes sha256 for all manifest entries and reports `[OK]` or mismatches.

**License:** If a trial license expires, the program refuses to run until you renew.

---

## 5) Configure

Open `config.py` and set:
- `input_dat` — path to your 4‑column data file
- `selected_terms` — list of pointing terms
- `output_dir` — where results are written (default: `My_Pointing_model_results`)
- `mode` — `"azel"` or `"hadec"`
- `lat` — observatory latitude (degrees)

(These fields match the v1.0.0 core expectations.)

---

## 6) Run

From the package directory:
```bash
python Pytheia100_main.py
```

You should see a banner with version, org, mode, and output directory.

---

## 7) Windows/PowerShell color tips

- We enable Windows “Virtual Terminal” mode and initialize `colorama` automatically. If your theme renders colored lines with low contrast or ANSI shows up literally, run in **monochrome** mode:
  ```powershell
  set PYTHEIA_COLOR=never
  python Pytheia100_main.py
  ```

This disables colored output at the source and keeps the core unchanged.

---

## 8) Outputs

Created under `output_dir` on each run:
- `combined_results_bayesian.html` — **self‑contained report** (plots + results + footer)
- `pytheia_audit.jsonl` — append‑only audit log

The report footer shows: version, UTC timestamp, and the licensed org.

---

## 9) Troubleshooting

- **Integrity warning** at startup → Regenerate the manifest (`INTEGRITY.json`) if you edited `Pytheia100_main.py`, and re‑sign it to `INTEGRITY.sig`. The main will warn or block depending on your policy.
- **“License expired/invalid”** → The signed license is expired or mismatched. Contact support for renewal.
- **“Failed to load or validate data file”** → Ensure `input_dat` points to an existing file and the format is 4 whitespace‑separated columns.
- **Blank/missing colored lines** in PowerShell → Use `set PYTHEIA_COLOR=never` to force monochrome.

---

## 10) Support

Orionis Group Company — Princeton, NJ, USA  
Email: support@orionisgroup.com
