# -*- coding: utf-8 -*-

# ==========================================================
# Pytheia v1.0.0 — Client Configuration (editable by users)
# ==========================================================

# Input data file: ASCII with 4 whitespace-separated columns (radians):
#   coord1_real, coord2_real, coord1_actual, coord2_actual
input_dat = "Ecam_astrometry_pm-02-04-2025.dat"

# Terms to include in the pointing model
# (Must be recognized by the core pointing model for v1.0.0)
selected_terms = ["AN", "AW", "IA", "IE", "CA", "TX", "ECES", "HZSZ2"]

# Where to write results (plots, HTML report, CSVs, JSONL audit, etc.)
output_dir = "My_Pointing_model_results"

# Telescope coordinate mode: 'azel' or 'hadec'
mode = "azel"

# Observatory latitude (degrees)
lat = -29.259

# Optional auxiliary inputs (advanced users)
aux1 = None
aux2 = None

# --------------------------------------------
# Feature flags (remain OFF for v1.0.0)
# --------------------------------------------
# If set True and a function `pointing_model(...)` is defined in this file,
# main will adopt it. Default False for v1.0.0 to ensure stability.
ALLOW_CUSTOM_POINTING_MODEL = False

# Example (do not enable in v1.0.0):
# def pointing_model(coord1, coord2, selected_terms, aux1=None, aux2=None):
#     import numpy as np
#     # return X, term_list
#     ...

# Trial license duration (days)
LICENSE_DURATION_DAYS = 30
