# inject_integrity.py — writes INTEGRITY.json sidecar for Pytheia100_main.py
import hashlib, json, os, sys

MAIN = "Pytheia100_main.py"
SIDECAR = "INTEGRITY.json"

def main():
    here = os.getcwd()
    main_path = os.path.join(here, MAIN)

    if not os.path.exists(main_path):
        print(f"[ERROR] {MAIN} not found in current directory: {here}", file=sys.stderr)
        sys.exit(1)

    with open(main_path, "rb") as f:
        h = hashlib.sha256(f.read()).hexdigest()

    # Write UTF-8 without BOM (Python's default)
    with open(os.path.join(here, SIDECAR), "w", encoding="utf-8") as f:
        json.dump({MAIN: h}, f, indent=2)

    print(f"[OK] Wrote {SIDECAR} with SHA256 = {h}")
    print(f"[INFO] Main path: {main_path}")

if __name__ == "__main__":
    main()
