# Pytheia v1.1.0 — Client Instructions (Advanced Package)

## Overview
Pytheia is a telescope pointing model framework developed by Orionis Group.
This package is licensed software — do not redistribute or modify files outside config.py.

## License and Trial Period
This package includes a **30-day trial license**. The countdown starts from the
moment you first run `Pytheia100_main.py`. During this trial period, all functionality
is fully available. After the 30-day period expires, the software will refuse to run
until you request and obtain a renewed license from Orionis Group.

The license mechanism is enforced through a signed `pytheia_license.json` file and
cannot be extended by editing configuration files. To continue beyond the trial, please
contact support@orionisgroup.com for renewal or purchase.

## How to Run
From the package directory:
    python Pytheia100_main.py

All results will be written to the output directory specified in config.py (default: My_Pointing_model_results).

## Files in This Package
- Pytheia100_main.py  
  Orchestrator entrypoint. Performs license + integrity checks, loads config,
  writes audit events, and delegates to the core.

- Pytheia100_core.py  
  Core compute engine (design matrix, Bayesian Ridge fit, diagnostics, plots,
  results, HTML bundling). **Cannot be run directly** — protected by a guard.
  Includes an HTML footer in the combined report.

- config.py  
  User-editable configuration file. Contains:
  - Input data file (ASCII format with 4 columns)
  - Selected pointing terms
  - Output directory
  - Telescope coordinate mode (azel / hadec)
  - Observatory latitude
  - Optional auxiliary parameters
  - **ALLOW_CUSTOM_POINTING_MODEL = True (New in v1.1.0)**

  In v1.1.0, advanced users can enable `ALLOW_CUSTOM_POINTING_MODEL` and define
  a function `pointing_model(...)` inside config.py. This allows editing or extending
  the set of pointing terms beyond the default selection.

- pytheia_guard.py  
  Licensing & integrity. Performs Ed25519 verification of license and manifest.

- INTEGRITY.json / INTEGRITY.sig  
  Integrity manifest and its Ed25519 signature.

- pytheia_public_key.pem  
  Public key used to verify integrity and licenses.

- pytheia_license.json  
  Per-client signed license (product=Pytheia100, version=1.1.0).

- Sample data file  
  Provided dataset for test runs.

- README_CLIENT.txt  
  This file.

## Outputs Produced (not shipped)
When you run Pytheia100_main.py, the following are created under `My_Pointing_model_results/`:
- pointing_analysis_<mode>.png   (12-panel diagnostic figure)
- pointing_results.txt           (fitted coefficients, uncertainties, RMS)
- correlation_matrix.csv         (correlation matrix table)
- combined_results_bayesian_ECAM.html (HTML report combining plots & results, now with footer)
- pytheia_audit.jsonl            (append-only audit log of runs)

## HTML Footer
The HTML report includes a standardized footer at the bottom of the page:
    Pytheia v1.1.0 | Report generated: YYYY-MM-DD HH:MM:SS UTC | Licensed to: <Organization> | © Orionis Group Company, Princeton NJ USA | support@orionisgroup.com

## Client Instructions
1. Edit `config.py` as needed:
   - Set your input data file
   - Adjust `selected_terms`
   - Update latitude and mode
   - (Optional, advanced) Define a custom pointing model function if ALLOW_CUSTOM_POINTING_MODEL = True
2. Run:
       python Pytheia100_main.py
3. Review results in `My_Pointing_model_results/`.

## Troubleshooting
- **Integrity check failed** → file tampered or mismatch with manifest. Reinstall package.
- **Trial expired / license invalid** → the 30-day trial period has ended or your license file is invalid. Contact support@orionisgroup.com for renewal.
- **Unknown term error** → term name not recognized in selected_terms or custom pointing_model.
- **Plots missing / empty** → check your input data file format (must be 4 columns, whitespace-separated).
- **Audit log not written** → ensure you have write permissions in the output directory.

## Support
Orionis Group Company  
Princeton, NJ, USA  
Email: support@orionisgroup.com
